import { BlockPermutation, Direction, EntityLeashableComponent, world } from '@minecraft/server';
import { ChrysalisBlock } from '../block/Chrysalis.js';
import { ChrysalisData } from '../block/ChrysalisData.js';
export class Caterpillar {
  static ENTITY_TYPE = 'sf_nba:caterpillar';
  constructor() {
    this.onTreeFoundEvent();
  }
  onTreeFoundEvent() {
    world.afterEvents.dataDrivenEntityTrigger.subscribe(({ entity: caterpillar }) => {
      const { dimension, location } = caterpillar;
      if (!dimension.getBlock(location)?.isAir) return;
      const log = caterpillar.getBlockFromViewDirection({ includeTypes: ChrysalisBlock.LOG_BLOCK_TYPES, maxDistance: 1 });
      if (!log?.block) return;
      const logFace = log.face;
      if (logFace === Direction.Down || logFace === Direction.Up) return;
      dimension.setBlockPermutation(location, BlockPermutation.resolve(ChrysalisBlock.BLOCK_TYPE, { 'minecraft:block_face': logFace.toLowerCase() }));
      const { nameTag } = caterpillar;
      const chrysalisDataKey = ChrysalisData.getChrysalisDataKey(dimension, location);
      if (nameTag) ChrysalisData.register(chrysalisDataKey, nameTag);
      else ChrysalisData.delete(chrysalisDataKey); 
      dimension.spawnParticle('sf_nba:chrysalis_form', location);
      const leashable = caterpillar.getComponent(EntityLeashableComponent.componentId);
      if (leashable?.isLeashed) leashable.unleash();
      caterpillar.remove();
    },
    {
      entityTypes: [Caterpillar.ENTITY_TYPE],
      eventTypes: ['sf_nba:caterpillar_tree_found']
    });
  }
}
new Caterpillar();